(function( $ ) {
    'use strict';
    var VisualDotsAnimation = {
        initDots: function () {
            elementorFrontend.hooks.addAction('frontend/element_ready/section', VisualDotsAnimation.initDotsWidget);
        },
        initDotsWidget: function ($scope) {
            var sectionId = $scope.data('id');
            var target = '.elementor-element-' + sectionId;
            var settings = {};
            if (window.isEditMode || window.elementorFrontend.isEditMode()) {
                var editorElements = null;
                var dotsAnimationArgs = {};

                if (!window.elementor.hasOwnProperty('elements')) {
                    return false;
                }

                editorElements = window.elementor.elements;

                if (!editorElements.models) {
                    return false;
                }

                $.each(editorElements.models, function (i, el) {
                    if (sectionId === el.id) {
                        dotsAnimationArgs = el.attributes.settings.attributes;
                    } else if (el.id === $scope.closest('.elementor-top-section').data('id')) {
                        $.each(el.attributes.elements.models, function (i, col) {
                            $.each(col.attributes.elements.models, function (i, subSec) {
                                dotsAnimationArgs = subSec.attributes.settings.attributes;
                            });
                        });
                    }
                    settings.switch = dotsAnimationArgs.marvy_enable_dots_animation;
                    settings.bgColor = dotsAnimationArgs.marvy_dots_animation_background_color;
                    settings.colorOne = dotsAnimationArgs.marvy_dots_animation_color;
                    settings.colorTwo = dotsAnimationArgs.marvy_dots_animation_color_two;
                    settings.size = dotsAnimationArgs.marvy_dots_animation_size;
                    settings.spacing = dotsAnimationArgs.marvy_dots_animation_spacing;
                });

            } else {
                settings.switch = $scope.data("marvy_enable_dots_animation");
                settings.bgColor = $scope.data("marvy_dots_animation_background_color");
                settings.colorOne = $scope.data("marvy_dots_animation_color");
                settings.colorTwo = $scope.data("marvy_dots_animation_color_two");
                settings.size = $scope.data("marvy_dots_animation_size");
                settings.spacing = $scope.data("marvy_dots_animation_spacing");
            }

            if (settings.switch) {
                dotsAnimation(target, settings, sectionId);
            }
        }
    };

    function dotsAnimation(target,settings,sectionId) {
        var checkElement = document.getElementsByClassName("marvy-dots-section-" + sectionId);
        if (checkElement.length >= 0) {

            var dots_div = document.createElement('div');
            dots_div.classList.add("marvy-dots-section-" + sectionId);

            document.querySelector(target).appendChild(dots_div);
            document.querySelector(target).classList.add("marvy-custom-dots-animation-section-" + sectionId);

            // Set Z-index for section container
            var dotsZindex = document.querySelector('.marvy-custom-dots-animation-section-'+sectionId+' .elementor-container');
            dotsZindex.style.zIndex = '99';

            // Set min height
            var dotsMinHeight = document.querySelector(".elementor-element-"+sectionId);
            dotsMinHeight.closest('.elementor-top-section').style.minHeight = "200px";


            var dotAnimation = VANTA.DOTS({
                el: ".marvy-dots-section-" + sectionId,
                mouseControls: true,
                touchControls: true,
                gyroControls: false,
                minHeight: 10.00,
                scale: 1.00,
                scaleMobile: 1.00,
                backgroundColor: settings.bgColor,
                color: settings.colorOne,
                color2: settings.colorTwo,
                size: settings.size,
                spacing: settings.spacing
            });
            render(dotAnimation,sectionId);
        }
        return true;
    }

    function render(animation,sectionId) {
        document.querySelector(".elementor-element-"+sectionId).addEventListener('DOMAttrModified', function(e){
            animation.resize();
        }, false);
    }

    $( window ).on('elementor/frontend/init', VisualDotsAnimation.initDots);
})( jQuery );